% MOMONGRID_CAPITAL: 
% Calculate and plot key moments in the capital model on the (N K x) grid 
% 
%  Nicolas Petrosky-Nadeau, Lu Zhang, and Lars Kuehn, January 2018


clear all; close all; format compact; 

load output_proj_capital

[kappa0, kappa1, eta, b, s, iota, xbar, rhox, stdx, beta, alpha, delta, a1, a2, nu] = params{:};
[P, X, N, K, NK, fspace, Nm, Km, Xm, Xp] = gridsetup{:};

nN      = length(N);
nK      = length(K);
nNK     = nN*nK;
nX      = length(X);
%
Nmin    = min(N);
Nmax    = max(N);
Kmin    = min(K);
Kmax    = max(K);
%
NKgrid  = NK;
Ngrid   = NKgrid(:, 1);
Kgrid   = NKgrid(:, 2);

% plot residuals on the job creation condition and investment Euler equation
a   = [aE(:); aI(:)];

err = residual_capital(a, params, gridsetup);
eE  = reshape(err(1 : nN*nK*nX), [nN nK nX]);
eI  = reshape(err(nN*nK*nX+1 : 2*nN*nK*nX), [nN nK nX]);

figure; mesh(X, N, squeeze(eE(:, 1, :)), 'FaceColor', [0.0431372560560703 0.517647087574005 0.780392169952393]); hold on;
mesh(X, N, squeeze(eE(:, ceil(nK/2), :)), 'FaceColor', [0.909803926944733 0.843137264251709 0.0745098069310188]); hold on; 
mesh(X, N, squeeze(eE(:, nK, :)), 'FaceColor', [0.847058832645416 0.160784319043159 0]); % legend('Low K', 'Mid K', 'High K');
ylabel('Employment', 'FontS', 25); xlabel('Productivity', 'FontS', 25); set(gca, 'FontS', 25);

figure; mesh(X, K, squeeze(eE(1, :, :)), 'FaceColor', [0.0431372560560703 0.517647087574005 0.780392169952393]); hold on;
mesh(X, K, squeeze(eE(ceil(nN/2), :, :)), 'FaceColor', [0.909803926944733 0.843137264251709 0.0745098069310188]); hold on; 
mesh(X, K, squeeze(eE(nN, :, :)), 'FaceColor', [0.847058832645416 0.160784319043159 0]); 
% legend('Low N', 'Mid N', 'High N');
ylabel('Capital', 'FontS', 25); xlabel('Productivity', 'FontS', 25); set(gca, 'FontS', 25);

figure; mesh(X, N, squeeze(eI(:, 1, :)), 'FaceColor', [0.0431372560560703 0.517647087574005 0.780392169952393]); hold on;
mesh(X, N, squeeze(eI(:, ceil(nK/2), :)), 'FaceColor', [0.909803926944733 0.843137264251709 0.0745098069310188]); hold on; 
mesh(X, N, squeeze(eI(:, nK, :)), 'FaceColor', [0.847058832645416 0.160784319043159 0]); % legend('Low K', 'Mid K', 'High K');
ylabel('Employment', 'FontS', 25); xlabel('Productivity', 'FontS', 25); set(gca, 'FontS', 25);

figure; mesh(X, K, squeeze(eI(1, :, :)), 'FaceColor', [0.0431372560560703 0.517647087574005 0.780392169952393]); hold on;
mesh(X, K, squeeze(eI(ceil(nN/2), :, :)), 'FaceColor', [0.909803926944733 0.843137264251709 0.0745098069310188]); hold on; 
mesh(X, K, squeeze(eI(nN, :, :)), 'FaceColor', [0.847058832645416 0.160784319043159 0]); % legend('Low N', 'Mid N', 'High N');
ylabel('Capital', 'FontS', 25); xlabel('Productivity', 'FontS', 25); set(gca, 'FontS', 25);


% plot optimal policy and value functions and quantity moments: 3d matrix convention
E            = reshape(funeval(aE, fspace, NK), [nN nK nX]);
I            = reshape(funeval(aI, fspace, NK), [nN nK nX]);

% save key moments on the grid for interpolation purpose later
save moments_theory_capital  E I 

