function diff = thetass_fn(x0, param_ss)

[kappa0, kappa1, eta, b, s, iota, xbar, rhox, stdx, beta, alpha, delta] = param_ss{:};

thetass  = x0;
qss      = (1 + thetass^iota)^(-1/iota);
fss      = qss*thetass;
uss      = s/(fss + s);
nss      = 1 - uss;
kappatss = kappa0 + kappa1*qss;

kss      = nss*( ( (alpha*exp(xbar))/(1/beta - 1 + delta) )^(1/(1 - alpha)) );
yss      = exp(xbar)*(kss^alpha)*(nss^(1 - alpha));

diff     = (kappatss/qss)*(1 - beta*(1-s)) - beta*( (1 - eta)*((1 - alpha)*yss/nss - b) - eta*kappatss*thetass );

