% DES_BarroUrsua
% 
% Calculate descriptive statistics for the C and Y data in Barro and Ursua
% international panel

clear all; clc; format short; format compact; 


% load Y_BarroUrsua
load Y_BarroUrsua_update_July2014

%   Name            Size            Bytes  Class     Attributes
% 
%   yArg          139x1              1112  double              
%   yAus          194x1              1552  double              
%   yAustria      144x1              1152  double              
%   yBel          168x1              1344  double              
%   yBra          164x1              1312  double              
%   yCan          144x1              1152  double              
%   yChi          154x1              1232  double              
%   yChina        124x1               992  double              
%   yCol          109x1               872  double              
%   yDen          196x1              1568  double              
%   yEgy          120x1               960  double              
%   yFin          154x1              1232  double              
%   yFra          194x1              1552  double              
%   yGer          163x1              1304  double              
%   yIce          144x1              1152  double              
%   yInd          142x1              1136  double              
%   yIndo         134x1              1072  double              
%   yIta          153x1              1224  double              
%   yJap          144x1              1152  double              
%   yKor          103x1               824  double              
%   yMex          119x1               952  double              
%   yNet          207x1              1656  double              
%   yNew          154x1              1232  double              
%   yNor          184x1              1472  double              
%   yPer          118x1               944  double              
%   yPor          149x1              1192  double              
%   yRus          154x1              1232  double              
%   ySaf          103x1               824  double              
%   ySpa          164x1              1312  double              
%   ySri          144x1              1152  double              
%   ySwe          214x1              1712  double              
%   ySwi          163x1              1304  double              
%   yTai          113x1               904  double              
%   yTur          139x1              1112  double              
%   yUK           184x1              1472  double              
%   yUS           224x1              1792  double              
%   yUru          144x1              1152  double              
%   yVen          131x1              1048  double              

Ty = [length(yArg) length(yAus) length(yAustria) length(yBel) length(yBra) length(yCan) length(yChi) length(yChina) length(yCol) length(yDen) ...
      length(yEgy) length(yFin) length(yFra) length(yGer) length(yIce) length(yInd) length(yIndo) length(yIta) length(yJap) ...
      length(yKor) length(yMex) length(yNet) length(yNew) length(yNor) length(yPer) length(yPor) length(yRus) length(ySaf) length(ySpa) ...
      length(ySri) length(ySwe) length(ySwi) length(yTai) length(yTur) length(yUK)  length(yUS) length(yUru) length(yVen)]; 

meanTy = mean(Ty)
 
% yout's columns are [mean vol skew kurt rho1 rho2 rho3 rho4 rho5]
yout = zeros(38, 9); 

gyArg     = log(yArg(2 : end)) - log(yArg(1 : end - 1)); 
gyAus     = log(yAus(2 : end)) - log(yAus(1 : end - 1)); 
gyAustria = log(yAustria(2 : end)) - log(yAustria(1 : end - 1)); 
gyBel     = log(yBel(2 : end)) - log(yBel(1 : end - 1)); 
gyBra     = log(yBra(2 : end)) - log(yBra(1 : end - 1)); 
gyBel     = log(yBel(2 : end)) - log(yBel(1 : end - 1)); 
gyCan     = log(yCan(2 : end)) - log(yCan(1 : end - 1)); 
gyChi     = log(yChi(2 : end)) - log(yChi(1 : end - 1)); 
gyChina   = log(yChina(2 : end)) - log(yChina(1 : end - 1)); 
gyCol     = log(yCol(2 : end)) - log(yCol(1 : end - 1)); 
gyDen     = log(yDen(2 : end)) - log(yDen(1 : end - 1)); 
gyEgy     = log(yEgy(2 : end)) - log(yEgy(1 : end - 1)); 
gyFin     = log(yFin(2 : end)) - log(yFin(1 : end - 1)); 
gyFra     = log(yFra(2 : end)) - log(yFra(1 : end - 1)); 
gyGer     = log(yGer(2 : end)) - log(yGer(1 : end - 1)); 
gyIce     = log(yIce(2 : end)) - log(yIce(1 : end - 1)); 
gyInd     = log(yInd(2 : end)) - log(yInd(1 : end - 1)); 
gyIndo    = log(yIndo(2 : end)) - log(yIndo(1 : end - 1)); 
gyIta     = log(yIta(2 : end)) - log(yIta(1 : end - 1)); 
gyJap     = log(yJap(2 : end)) - log(yJap(1 : end - 1)); 
gyKor     = log(yKor(2 : end)) - log(yKor(1 : end - 1)); 
gyMex     = log(yMex(2 : end)) - log(yMex(1 : end - 1)); 
gyNet     = log(yNet(2 : end)) - log(yNet(1 : end - 1)); 
gyNew     = log(yNew(2 : end)) - log(yNew(1 : end - 1)); 
gyNor     = log(yNor(2 : end)) - log(yNor(1 : end - 1)); 
gyPer     = log(yPer(2 : end)) - log(yPer(1 : end - 1)); 
gyPor     = log(yPor(2 : end)) - log(yPor(1 : end - 1)); 
gyRus     = log(yRus(2 : end)) - log(yRus(1 : end - 1)); 
gySaf     = log(ySaf(2 : end)) - log(ySaf(1 : end - 1)); 
gySpa     = log(ySpa(2 : end)) - log(ySpa(1 : end - 1)); 
gySri     = log(ySri(2 : end)) - log(ySri(1 : end - 1)); 
gySwe     = log(ySwe(2 : end)) - log(ySwe(1 : end - 1)); 
gySwi     = log(ySwi(2 : end)) - log(ySwi(1 : end - 1)); 
gyTai     = log(yTai(2 : end)) - log(yTai(1 : end - 1)); 
gyTur     = log(yTur(2 : end)) - log(yTur(1 : end - 1)); 
gyUK      = log(yUK(2 : end)) - log(yUK(1 : end - 1)); 
gyUS      = log(yUS(2 : end)) - log(yUS(1 : end - 1)); 
gyUru     = log(yUru(2 : end)) - log(yUru(1 : end - 1)); 
gyVen     = log(yVen(2 : end)) - log(yVen(1 : end - 1)); 


yout(1, :)  = [100*mean(gyArg) 100*std(gyArg) skewness(gyArg) kurtosis(gyArg) myAutoCorr(gyArg, [1 2 3 4 5])']; 
yout(2, :)  = [100*mean(gyAus) 100*std(gyAus) skewness(gyAus) kurtosis(gyAus) myAutoCorr(gyAus, [1 2 3 4 5])']; 
yout(3, :)  = [100*mean(gyAustria) 100*std(gyAustria) skewness(gyAustria) kurtosis(gyAustria) myAutoCorr(gyAustria, [1 2 3 4 5])']; 
yout(4, :)  = [100*mean(gyBel) 100*std(gyBel) skewness(gyBel) kurtosis(gyBel) myAutoCorr(gyBel, [1 2 3 4 5])']; 
yout(5, :)  = [100*mean(gyBra) 100*std(gyBra) skewness(gyBra) kurtosis(gyBra) myAutoCorr(gyBra, [1 2 3 4 5])']; 
yout(6, :)  = [100*mean(gyCan) 100*std(gyCan) skewness(gyCan) kurtosis(gyCan) myAutoCorr(gyCan, [1 2 3 4 5])']; 
yout(7, :)  = [100*mean(gyChi) 100*std(gyChi) skewness(gyChi) kurtosis(gyChi) myAutoCorr(gyChi, [1 2 3 4 5])']; 
yout(8, :)  = [100*mean(gyChina) 100*std(gyChina) skewness(gyChina) kurtosis(gyChina) myAutoCorr(gyChina, [1 2 3 4 5])']; 
yout(9, :)  = [100*mean(gyCol) 100*std(gyCol) skewness(gyCol) kurtosis(gyCol) myAutoCorr(gyCol, [1 2 3 4 5])']; 
yout(10, :) = [100*mean(gyDen) 100*std(gyDen) skewness(gyDen) kurtosis(gyDen) myAutoCorr(gyDen, [1 2 3 4 5])']; 
yout(11, :) = [100*mean(gyEgy) 100*std(gyEgy) skewness(gyEgy) kurtosis(gyEgy) myAutoCorr(gyEgy, [1 2 3 4 5])']; 
yout(12, :) = [100*mean(gyFin) 100*std(gyFin) skewness(gyFin) kurtosis(gyFin) myAutoCorr(gyFin, [1 2 3 4 5])']; 
yout(13, :) = [100*mean(gyFra) 100*std(gyFra) skewness(gyFra) kurtosis(gyFra) myAutoCorr(gyFra, [1 2 3 4 5])']; 
yout(14, :) = [100*mean(gyGer) 100*std(gyGer) skewness(gyGer) kurtosis(gyGer) myAutoCorr(gyGer, [1 2 3 4 5])']; 
yout(15, :) = [100*mean(gyIce) 100*std(gyIce) skewness(gyIce) kurtosis(gyIce) myAutoCorr(gyIce, [1 2 3 4 5])']; 
yout(16, :) = [100*mean(gyInd) 100*std(gyInd) skewness(gyInd) kurtosis(gyInd) myAutoCorr(gyInd, [1 2 3 4 5])']; 
yout(17, :) = [100*mean(gyIndo) 100*std(gyIndo) skewness(gyIndo) kurtosis(gyIndo) myAutoCorr(gyIndo, [1 2 3 4 5])']; 
yout(18, :) = [100*mean(gyIta) 100*std(gyIta) skewness(gyIta) kurtosis(gyIta) myAutoCorr(gyIta, [1 2 3 4 5])']; 
yout(19, :) = [100*mean(gyJap) 100*std(gyJap) skewness(gyJap) kurtosis(gyJap) myAutoCorr(gyJap, [1 2 3 4 5])']; 
yout(20, :) = [100*mean(gyKor) 100*std(gyKor) skewness(gyKor) kurtosis(gyKor) myAutoCorr(gyKor, [1 2 3 4 5])']; 
yout(21, :) = [100*mean(gyMex) 100*std(gyMex) skewness(gyMex) kurtosis(gyMex) myAutoCorr(gyMex, [1 2 3 4 5])']; 
yout(22, :) = [100*mean(gyNet) 100*std(gyNet) skewness(gyNet) kurtosis(gyNet) myAutoCorr(gyNet, [1 2 3 4 5])']; 
yout(23, :) = [100*mean(gyNew) 100*std(gyNew) skewness(gyNew) kurtosis(gyNew) myAutoCorr(gyNew, [1 2 3 4 5])']; 
yout(24, :) = [100*mean(gyNor) 100*std(gyNor) skewness(gyNor) kurtosis(gyNor) myAutoCorr(gyNor, [1 2 3 4 5])']; 
yout(25, :) = [100*mean(gyPer) 100*std(gyPer) skewness(gyPer) kurtosis(gyPer) myAutoCorr(gyPer, [1 2 3 4 5])']; 
yout(26, :) = [100*mean(gyPor) 100*std(gyPor) skewness(gyPor) kurtosis(gyPor) myAutoCorr(gyPor, [1 2 3 4 5])']; 
yout(27, :) = [100*mean(gyRus) 100*std(gyRus) skewness(gyRus) kurtosis(gyRus) myAutoCorr(gyRus, [1 2 3 4 5])']; 
yout(28, :) = [100*mean(gySaf) 100*std(gySaf) skewness(gySaf) kurtosis(gySaf) myAutoCorr(gySaf, [1 2 3 4 5])']; 
yout(29, :) = [100*mean(gySpa) 100*std(gySpa) skewness(gySpa) kurtosis(gySpa) myAutoCorr(gySpa, [1 2 3 4 5])']; 
yout(30, :) = [100*mean(gySri) 100*std(gySri) skewness(gySri) kurtosis(gySri) myAutoCorr(gySri, [1 2 3 4 5])']; 
yout(31, :) = [100*mean(gySwe) 100*std(gySwe) skewness(gySwe) kurtosis(gySwe) myAutoCorr(gySwe, [1 2 3 4 5])']; 
yout(32, :) = [100*mean(gySwi) 100*std(gySwi) skewness(gySwi) kurtosis(gySwi) myAutoCorr(gySwi, [1 2 3 4 5])']; 
yout(33, :) = [100*mean(gyTai) 100*std(gyTai) skewness(gyTai) kurtosis(gyTai) myAutoCorr(gyTai, [1 2 3 4 5])']; 
yout(34, :) = [100*mean(gyTur) 100*std(gyTur) skewness(gyTur) kurtosis(gyTur) myAutoCorr(gyTur, [1 2 3 4 5])']; 
yout(35, :) = [100*mean(gyUK) 100*std(gyUK) skewness(gyUK) kurtosis(gyUK) myAutoCorr(gyUK, [1 2 3 4 5])']; 
yout(36, :) = [100*mean(gyUS) 100*std(gyUS) skewness(gyUS) kurtosis(gyUS) myAutoCorr(gyUS, [1 2 3 4 5])']; 
yout(37, :) = [100*mean(gyUru) 100*std(gyUru) skewness(gyUru) kurtosis(gyUru) myAutoCorr(gyUru, [1 2 3 4 5])']; 
yout(38, :) = [100*mean(gyVen) 100*std(gyVen) skewness(gyVen) kurtosis(gyVen) myAutoCorr(gyVen, [1 2 3 4 5])']; 

yout
myout  = mean(yout)
medout = median(yout)


% load C_BarroUrsua
load C_BarroUrsua_update_July2014

%   Name          Size              Bytes  Class     32 countries in total
%   cArg      135x1              1080  double              
%   cAus      109x1               872  double              
%   cBel       97x1               776  double              
%   cBra      109x1               872  double              
%   cCan      139x1              1112  double              
%   cChi      110x1               880  double              
%   cCol       85x1               680  double              
%   cDen      166x1              1328  double              
%   cEgy      116x1               928  double              
%   cFin      150x1              1200  double              
%   cFra      186x1              1488  double              
%   cGer      159x1              1272  double              
%   cGre       72x1               576  double              
%   cInd       91x1               728  double              
%   cIta      149x1              1192  double              
%   cJap      136x1              1088  double              
%   cKor       99x1               792  double              
%   cMex      110x1               880  double              
%   cNet      196x1              1568  double              
%   cNew      132x1              1056  double              
%   cNor      180x1              1440  double              
%   cPer      114x1               912  double              
%   cPor      100x1               800  double              
%   cRus      125x1              1000  double              
%   cSpa      160x1              1280  double              
%   cSwe      210x1              1680  double              
%   cSwi      159x1              1272  double              
%   cTai      109x1               872  double              
%   cTur      135x1              1080  double              
%   cUK       180x1              1440  double              
%   cUS       176x1              1408  double              
%   cVen       87x1               696  double              
  
Tc = [length(cArg) length(cAus) length(cBel) length(cBra) length(cCan) length(cChi) length(cCol) length(cDen) length(cEgy) ...
      length(cFin) length(cFra) length(cGer) length(cGre) length(cInd) length(cIta) ...
      length(cJap) length(cKor) length(cMex) length(cNet) length(cNew) length(cNor) length(cPer) length(cPor) ...
      length(cRus) length(cSpa) length(cSwe) length(cSwi) length(cTai) length(cTur) length(cUK)  length(cUS) length(cVen)]; 

meanTc = mean(Tc)
  
% yout's columns are [mean vol skew kurt rho1 rho2 rho3 rho4 rho5]
cout = zeros(32, 9); 

gcArg     = log(cArg(2 : end)) - log(cArg(1 : end - 1)); 
gcAus     = log(cAus(2 : end)) - log(cAus(1 : end - 1)); 
gcBel     = log(cBel(2 : end)) - log(cBel(1 : end - 1)); 
gcBra     = log(cBra(2 : end)) - log(cBra(1 : end - 1)); 
gcCan     = log(cCan(2 : end)) - log(cCan(1 : end - 1)); 
gcChi     = log(cChi(2 : end)) - log(cChi(1 : end - 1)); 
gcCol     = log(cCol(2 : end)) - log(cCol(1 : end - 1)); 
gcDen     = log(cDen(2 : end)) - log(cDen(1 : end - 1)); 
gcEgy     = log(cEgy(2 : end)) - log(cEgy(1 : end - 1)); 
gcFin     = log(cFin(2 : end)) - log(cFin(1 : end - 1)); 
gcFra     = log(cFra(2 : end)) - log(cFra(1 : end - 1)); 
gcGer     = log(cGer(2 : end)) - log(cGer(1 : end - 1)); 
gcGre     = log(cGre(2 : end)) - log(cGre(1 : end - 1)); 
gcInd     = log(cInd(2 : end)) - log(cInd(1 : end - 1)); 
gcIta     = log(cIta(2 : end)) - log(cIta(1 : end - 1)); 
gcJap     = log(cJap(2 : end)) - log(cJap(1 : end - 1)); 
gcKor     = log(cKor(2 : end)) - log(cKor(1 : end - 1)); 
gcMex     = log(cMex(2 : end)) - log(cMex(1 : end - 1)); 
gcNet     = log(cNet(2 : end)) - log(cNet(1 : end - 1)); 
gcNew     = log(cNew(2 : end)) - log(cNew(1 : end - 1)); 
gcNor     = log(cNor(2 : end)) - log(cNor(1 : end - 1)); 
gcPer     = log(cPer(2 : end)) - log(cPer(1 : end - 1));    gcPer(end) = [];
gcPor     = log(cPor(2 : end)) - log(cPor(1 : end - 1)); 
gcRus     = log(cRus(2 : end)) - log(cRus(1 : end - 1)); 
gcSpa     = log(cSpa(2 : end)) - log(cSpa(1 : end - 1)); 
gcSwe     = log(cSwe(2 : end)) - log(cSwe(1 : end - 1)); 
gcSwi     = log(cSwi(2 : end)) - log(cSwi(1 : end - 1)); 
gcTai     = log(cTai(2 : end)) - log(cTai(1 : end - 1)); 
gcTur     = log(cTur(2 : end)) - log(cTur(1 : end - 1)); 
gcUK      = log(cUK(2 : end)) - log(cUK(1 : end - 1)); 
gcUS      = log(cUS(2 : end)) - log(cUS(1 : end - 1)); 
gcVen     = log(cVen(2 : end)) - log(cVen(1 : end - 1)); 


cout(1, :)  = [100*mean(gcArg) 100*std(gcArg) skewness(gcArg) kurtosis(gcArg) myAutoCorr(gcArg, [1 2 3 4 5])']; 
cout(2, :)  = [100*mean(gcAus) 100*std(gcAus) skewness(gcAus) kurtosis(gcAus) myAutoCorr(gcAus, [1 2 3 4 5])']; 
cout(3, :)  = [100*mean(gcBel) 100*std(gcBel) skewness(gcBel) kurtosis(gcBel) myAutoCorr(gcBel, [1 2 3 4 5])']; 
cout(4, :)  = [100*mean(gcBra) 100*std(gcBra) skewness(gcBra) kurtosis(gcBra) myAutoCorr(gcBra, [1 2 3 4 5])']; 
cout(5, :)  = [100*mean(gcCan) 100*std(gcCan) skewness(gcCan) kurtosis(gcCan) myAutoCorr(gcCan, [1 2 3 4 5])']; 
cout(6, :)  = [100*mean(gcChi) 100*std(gcChi) skewness(gcChi) kurtosis(gcChi) myAutoCorr(gcChi, [1 2 3 4 5])']; 
cout(7, :)  = [100*mean(gcCol) 100*std(gcCol) skewness(gcCol) kurtosis(gcCol) myAutoCorr(gcCol, [1 2 3 4 5])']; 
cout(8, :)  = [100*mean(gcDen) 100*std(gcDen) skewness(gcDen) kurtosis(gcDen) myAutoCorr(gcDen, [1 2 3 4 5])']; 
cout(9, :)  = [100*mean(gcEgy) 100*std(gcEgy) skewness(gcEgy) kurtosis(gcEgy) myAutoCorr(gcEgy, [1 2 3 4 5])']; 
cout(10, :) = [100*mean(gcFin) 100*std(gcFin) skewness(gcFin) kurtosis(gcFin) myAutoCorr(gcFin, [1 2 3 4 5])']; 
cout(11, :) = [100*mean(gcFra) 100*std(gcFra) skewness(gcFra) kurtosis(gcFra) myAutoCorr(gcFra, [1 2 3 4 5])']; 
cout(12, :) = [100*mean(gcGer) 100*std(gcGer) skewness(gcGer) kurtosis(gcGer) myAutoCorr(gcGer, [1 2 3 4 5])']; 
cout(13, :) = [100*mean(gcGre) 100*std(gcGre) skewness(gcGre) kurtosis(gcGre) myAutoCorr(gcGre, [1 2 3 4 5])']; 
cout(14, :) = [100*mean(gcInd) 100*std(gcInd) skewness(gcInd) kurtosis(gcInd) myAutoCorr(gcInd, [1 2 3 4 5])']; 
cout(15, :) = [100*mean(gcIta) 100*std(gcIta) skewness(gcIta) kurtosis(gcIta) myAutoCorr(gcIta, [1 2 3 4 5])']; 
cout(16, :) = [100*mean(gcJap) 100*std(gcJap) skewness(gcJap) kurtosis(gcJap) myAutoCorr(gcJap, [1 2 3 4 5])']; 
cout(17, :) = [100*mean(gcKor) 100*std(gcKor) skewness(gcKor) kurtosis(gcKor) myAutoCorr(gcKor, [1 2 3 4 5])']; 
cout(18, :) = [100*mean(gcMex) 100*std(gcMex) skewness(gcMex) kurtosis(gcMex) myAutoCorr(gcMex, [1 2 3 4 5])']; 
cout(19, :) = [100*mean(gcNet) 100*std(gcNet) skewness(gcNet) kurtosis(gcNet) myAutoCorr(gcNet, [1 2 3 4 5])']; 
cout(20, :) = [100*mean(gcNew) 100*std(gcNew) skewness(gcNew) kurtosis(gcNew) myAutoCorr(gcNew, [1 2 3 4 5])']; 
cout(21, :) = [100*mean(gcNor) 100*std(gcNor) skewness(gcNor) kurtosis(gcNor) myAutoCorr(gcNor, [1 2 3 4 5])']; 
cout(22, :) = [100*mean(gcPer) 100*std(gcPer) skewness(gcPer) kurtosis(gcPer) myAutoCorr(gcPer, [1 2 3 4 5])']; 
cout(23, :) = [100*mean(gcPor) 100*std(gcPor) skewness(gcPor) kurtosis(gcPor) myAutoCorr(gcPor, [1 2 3 4 5])']; 
cout(24, :) = [100*mean(gcRus) 100*std(gcRus) skewness(gcRus) kurtosis(gcRus) myAutoCorr(gcRus, [1 2 3 4 5])']; 
cout(25, :) = [100*mean(gcSpa) 100*std(gcSpa) skewness(gcSpa) kurtosis(gcSpa) myAutoCorr(gcSpa, [1 2 3 4 5])']; 
cout(26, :) = [100*mean(gcSwe) 100*std(gcSwe) skewness(gcSwe) kurtosis(gcSwe) myAutoCorr(gcSwe, [1 2 3 4 5])']; 
cout(27, :) = [100*mean(gcSwi) 100*std(gcSwi) skewness(gcSwi) kurtosis(gcSwi) myAutoCorr(gcSwi, [1 2 3 4 5])']; 
cout(28, :) = [100*mean(gcTai) 100*std(gcTai) skewness(gcTai) kurtosis(gcTai) myAutoCorr(gcTai, [1 2 3 4 5])']; 
cout(29, :) = [100*mean(gcTur) 100*std(gcTur) skewness(gcTur) kurtosis(gcTur) myAutoCorr(gcTur, [1 2 3 4 5])']; 
cout(30, :) = [100*mean(gcUK) 100*std(gcUK) skewness(gcUK) kurtosis(gcUK) myAutoCorr(gcUK, [1 2 3 4 5])']; 
cout(31, :) = [100*mean(gcUS) 100*std(gcUS) skewness(gcUS) kurtosis(gcUS) myAutoCorr(gcUS, [1 2 3 4 5])']; 
cout(32, :) = [100*mean(gcVen) 100*std(gcVen) skewness(gcVen) kurtosis(gcVen) myAutoCorr(gcVen, [1 2 3 4 5])']; 

cout
mcout   = mean(cout)
medcout = median(cout)





if 1
load  AP_GFD_DMS_July2014

%   Name            Size            Bytes  Class     Attributes
%   bAus          152x1              1216  double              
%   bAustria      113x1               904  double              
%   bBel          113x1               904  double              
%   bCan          113x1               904  double              
%   bDen          113x1               904  double              
%   bFin          113x1               904  double              
%   bFra          118x1               944  double              
%   bGer          144x1              1152  double              
%   bIre          113x1               904  double              
%   bIta          113x1               904  double              
%   bJap          113x1               904  double              
%   bNet          113x1               904  double              
%   bNew          113x1               904  double              
%   bNor          113x1               904  double              
%   bSaf          113x1               904  double              
%   bSpa          113x1               904  double              
%   bSwe          113x1               904  double              
%   bSwi          113x1               904  double              
%   bUK           213x1              1704  double              
%   bUS           178x1              1424  double              
%   rAus          138x1              1104  double              
%   rAustria      113x1               904  double              
%   rBel          113x1               904  double              
%   rCan          113x1               904  double              
%   rDen          113x1               904  double              
%   rFin          113x1               904  double              
%   rFra          118x1               944  double              
%   rGer          144x1              1152  double              
%   rIre          113x1               904  double              
%   rIta          113x1               904  double              
%   rJap          113x1               904  double              
%   rNet          113x1               904  double              
%   rNew          113x1               904  double              
%   rNor          113x1               904  double              
%   rSaf          113x1               904  double              
%   rSpa          113x1               904  double              
%   rSwe          113x1               904  double              
%   rSwi          113x1               904  double              
%   rUK           213x1              1704  double              
%   rUS           178x1              1424  double              

apout = zeros(20, 7); 

T = [length(bAus) length(bAustria) length(bBel) length(bCan) length(bDen) length(bFin) length(bFra) length(bGer) length(bIre) length(bIta) ...
     length(bJap) length(bNet)     length(bNew) length(bNor) length(bSaf) length(bSpa) length(bSwe) length(bSwi) length(bUK)  length(bUS)]; 

r    = NaN*ones(max(T), length(T)); 
bill = NaN*ones(max(T), length(T)); 

r(1 : length(rAus), 1)     = rAus;        bill(1 : length(bAus), 1)     = bAus; 
r(1 : length(rAustria), 2) = rAustria;    bill(1 : length(bAustria), 2) = bAustria;    
r(1 : length(rBel), 3)     = rBel;        bill(1 : length(bBel), 3)     = bBel; 
r(1 : length(rCan), 4)     = rCan;        bill(1 : length(bCan), 4)     = bCan; 
r(1 : length(rDen), 5)     = rDen;        bill(1 : length(bDen), 5)     = bDen;
r(1 : length(rFin), 6)     = rFin;        bill(1 : length(bFin), 6)     = bFin;
r(1 : length(rFra), 7)     = rFra;        bill(1 : length(bFra), 7)     = bFra;
r(1 : length(rGer), 8)     = rGer;        bill(1 : length(bGer), 8)     = bGer;
r(1 : length(rIre), 9)     = rIre;        bill(1 : length(bIre), 9)     = bIre;
r(1 : length(rIta), 10)    = rIta;        bill(1 : length(bIta), 10)    = bIta;
r(1 : length(rJap), 11)    = rJap;        bill(1 : length(bJap), 11)    = bJap;
r(1 : length(rNet), 12)    = rNet;        bill(1 : length(bNet), 12)    = bNet;
r(1 : length(rNew), 13)    = rNew;        bill(1 : length(bNew), 13)    = bNew;
r(1 : length(rNor), 14)    = rNor;        bill(1 : length(bNor), 14)    = bNor;
r(1 : length(rSaf), 15)    = rSaf;        bill(1 : length(bSaf), 15)    = bSaf;
r(1 : length(rSpa), 16)    = rSpa;        bill(1 : length(bSpa), 16)    = bSpa;
r(1 : length(rSwe), 17)    = rSwe;        bill(1 : length(bSwe), 17)    = bSwe;
r(1 : length(rSwi), 18)    = rSwi;        bill(1 : length(bSwi), 18)    = bSwi;
r(1 : length(rUK), 19)     = rUK;         bill(1 : length(bUK), 19)     = bUK;
r(1 : length(rUS), 20)     = rUS;         bill(1 : length(bUS), 20)     = bUS;

% 
for n = 1 : length(T)    
    
    % obtain country n's r and bill vectors 
    rvec    = r(1 : T(n), n);
    bvec    = bill(1 : T(n), n); 
    % 
    apout(n, :) = [ mean(rvec) std(rvec) mean(bvec) std(bvec) mean(rvec - bvec) ...
        (1 - .29)*mean(rvec - bvec) std( .29*bvec + (1 - .29)*rvec ) ]; 
    
end

apout
mapout = mean(apout)
end

