% MomentsU.m
% Calculate the unemployment rate moments
% 

clear all; format compact; format short; clc;

hp_smooth = 1600;           % hp_smooth = 10^5; 

% long sample, 1929:m4 - 2013:m12, PNZ (2013, Unemployment Crises) data on unemployment and vacancy rates
load UV_pnz

meanU = mean(U)
skewU = skewness(U)
kurtU = kurtosis(U)


Uq = mean(reshape(U, [3 1017/3]))';
U_hp  = (Uq - mean(Uq))/mean(Uq);
U_d   = U_hp - hpfilter(U_hp, hp_smooth);

std_U = std(U_d)

