clear all; close all; clc;
 
%--------------------------------------------------------------------------
% Load in data
%--------------------------------------------------------------------------
Data_m = xlsread('US_UVdata_1929_2013.xlsx','monthly');
Data_m = Data_m(~isnan(Data_m(:,1)),:);

date_m    = Data_m(:,1);
date_plot = Data_m(:,2);
V_m       = Data_m(:,3);
U_m       = Data_m(:,4);

Dec_39 = find(date_m==1939+11/12);
Jan_40 = find(date_m==1940);
Dec_50 = find(date_m==1950+11/12);


%--------------------------------------------------------------------------
% Some graphing settings
%--------------------------------------------------------------------------
scale  = 5;
wratio = 1.33;
posxy  = 1;

%--------------------------------------------------------------------------
% Graphing
%--------------------------------------------------------------------------

% US Beveridge curve, April 1929 - December 2013
xyratio = (9/9); %16/9
figure1 = figure;
set(figure1,'units','inches','position',[posxy posxy wratio*xyratio*scale wratio*scale]);
axes1 = axes('Parent',figure1,'FontSize',16);
set(axes1,'units','inches','position',[posxy posxy xyratio*scale scale]);
hold on; grid on;
scatter(U_m(1:Dec_39),V_m(1:Dec_39),49,'r'); %circles
scatter(U_m(Jan_40:Dec_50),V_m(Jan_40:Dec_50),64,'MarkerFaceColor',[0 0 0],'MarkerEdgeColor',[0 0 0],...
    'Marker','diamond'); %circles
scatter(U_m(Dec_50+1:end),V_m(Dec_50+1:end),64,'b','s','filled'); 
set(axes1,'ylim',[0 6],'xlim',[0 30]);
xlabel('Unemployment rate (in percent)','FontSize',25);
ylabel('Vacancy rate (in percent)','FontSize',25);
%legend('1929:04-1941:12','1942:01-2013:12','location','best');
%legend('boxoff');
set(legend,'FontSize',25);
saveas(gcf,'Beveridge_29_13_2split','epsc');


% vacancy and unemployment rates, April 1929 - December 2013
set(figure,'units','inches','position',[posxy posxy wratio*xyratio*scale wratio*scale]);
[AX,H1,H2] = plotyy(date_plot,U_m,date_plot,V_m);
set(AX,'units','inches','position',[posxy posxy xyratio*scale scale]);
set(get(AX(1),'Ylabel'),'String','Unemployment rate (in percent)','FontSize',25);
set(get(AX(2),'Ylabel'),'String','Vacancy rate (in percent)','FontSize',25);
set(AX,'xlim',[datenum('1929','yyyy') datenum('2014','yyyy')]);
datetick(AX(1),'x','yyyy','keeplimits'); datetick(AX(2),'x','yyyy','keeplimits');
set(AX(1),'ylim',[0 30],'ytick',[linspace(0,30,6)]);
set(AX(2),'ylim',[0 10],'ytick',[linspace(0,10,6)]);
set(AX,'FontSize',16,'YColor','k');
set(H1,'LineWidth',5);
set(H2,'color','r','linestyle','--','LineWidth',5);
%legend('Unemployment rate (left axis)','Vacancy rate (right axis)','location','best');
%legend('boxoff');
set(legend,'FontSize',25);
grid('on'); box('off'); shadenber;
saveas(gcf,'V_U_29_13','epsc');


