% DISASTER_MOMENTS_COUNTRIES_C:
%   Calculate disaster moments in the updated Barro-Ursua C and Y data, following 
% the Barro and Ursua peak-to-trough measurement of disasters
% 
% July 4, 2014


clear all; close all; clc; format compact; format long; 

load C_BarroUrsua_update_July2014


% define C growth rates for countries
gcArg     = log(cArg(2 : end)) - log(cArg(1 : end - 1)); gcAus     = log(cAus(2 : end)) - log(cAus(1 : end - 1)); gcBel     = log(cBel(2 : end)) - log(cBel(1 : end - 1)); 
gcBra     = log(cBra(2 : end)) - log(cBra(1 : end - 1)); gcCan     = log(cCan(2 : end)) - log(cCan(1 : end - 1)); gcChi     = log(cChi(2 : end)) - log(cChi(1 : end - 1)); 
gcCol     = log(cCol(2 : end)) - log(cCol(1 : end - 1)); gcDen     = log(cDen(2 : end)) - log(cDen(1 : end - 1)); gcEgy     = log(cEgy(2 : end)) - log(cEgy(1 : end - 1)); 
gcFin     = log(cFin(2 : end)) - log(cFin(1 : end - 1)); gcFra     = log(cFra(2 : end)) - log(cFra(1 : end - 1)); gcGer     = log(cGer(2 : end)) - log(cGer(1 : end - 1)); 
gcGre     = log(cGre(2 : end)) - log(cGre(1 : end - 1)); gcInd     = log(cInd(2 : end)) - log(cInd(1 : end - 1)); gcIta     = log(cIta(2 : end)) - log(cIta(1 : end - 1)); 
gcJap     = log(cJap(2 : end)) - log(cJap(1 : end - 1)); gcKor     = log(cKor(2 : end)) - log(cKor(1 : end - 1)); gcMex     = log(cMex(2 : end)) - log(cMex(1 : end - 1)); 
gcNet     = log(cNet(2 : end)) - log(cNet(1 : end - 1)); gcNew     = log(cNew(2 : end)) - log(cNew(1 : end - 1)); gcNor     = log(cNor(2 : end)) - log(cNor(1 : end - 1)); 
gcPer     = log(cPer(2 : end)) - log(cPer(1 : end - 1)); gcPor     = log(cPor(2 : end)) - log(cPor(1 : end - 1)); gcRus     = log(cRus(2 : end)) - log(cRus(1 : end - 1)); 
gcSpa     = log(cSpa(2 : end)) - log(cSpa(1 : end - 1)); gcSwe     = log(cSwe(2 : end)) - log(cSwe(1 : end - 1)); gcSwi     = log(cSwi(2 : end)) - log(cSwi(1 : end - 1)); 
gcTai     = log(cTai(2 : end)) - log(cTai(1 : end - 1)); gcTur     = log(cTur(2 : end)) - log(cTur(1 : end - 1)); gcUK      = log(cUK(2 : end)) - log(cUK(1 : end - 1)); 
gcUS      = log(cUS(2 : end)) - log(cUS(1 : end - 1));   gcVen     = log(cVen(2 : end)) - log(cVen(1 : end - 1)); 

% use patched nan to put all the gc vectors in a matrix of max(T) by N = columns of T
T = [length(gcArg) length(gcAus) length(gcBel) length(gcBra) length(gcCan) length(gcChi) length(gcCol) length(gcDen) length(gcEgy) length(gcFin) ...
     length(gcFra) length(gcGer) length(gcGre) length(gcInd) length(gcIta) length(gcJap) length(gcKor) length(gcMex) length(gcNet) length(gcNew) ...
     length(gcNor) length(gcPer) length(gcPor) length(gcRus) length(gcSpa) length(gcSwe) length(gcSwi) length(gcTai) length(gcTur) length(gcUK)  ...
     length(gcUS)  length(gcVen)]; 

gC = NaN*ones(max(T), length(T)); 
gC(1 : length(gcArg), 1)     = gcArg;   gC(1 : length(gcAus), 2)     = gcAus;   gC(1 : length(gcBel), 3)     = gcBel;   gC(1 : length(gcBra), 4)     = gcBra;   gC(1 : length(gcCan), 5)     = gcCan; 
gC(1 : length(gcChi), 6)     = gcChi;   gC(1 : length(gcCol), 7)     = gcCol;   gC(1 : length(gcDen), 8)     = gcDen;   gC(1 : length(gcEgy), 9)     = gcEgy;   gC(1 : length(gcFin), 10)    = gcFin; 
gC(1 : length(gcFra), 11)    = gcFra;   gC(1 : length(gcGer), 12)    = gcGer;   gC(1 : length(gcGre), 13)    = gcGre;   gC(1 : length(gcInd), 14)    = gcInd;   gC(1 : length(gcIta), 15)    = gcIta; 
gC(1 : length(gcJap), 16)    = gcJap;   gC(1 : length(gcKor), 17)    = gcKor;   gC(1 : length(gcMex), 18)    = gcMex;   gC(1 : length(gcNet), 19)    = gcNet;   gC(1 : length(gcNew), 20)    = gcNew;   
gC(1 : length(gcNor), 21)    = gcNor;   gC(1 : length(gcPer), 22)    = gcPer;   gC(1 : length(gcPor), 23)    = gcPor;   gC(1 : length(gcRus), 24)    = gcRus;   gC(1 : length(gcSpa), 25)    = gcSpa;   
gC(1 : length(gcSwe), 26)    = gcSwe;   gC(1 : length(gcSwi), 27)    = gcSwi;   gC(1 : length(gcTai), 28)    = gcTai;   gC(1 : length(gcTur), 29)    = gcTur;   gC(1 : length(gcUK), 30)     = gcUK; 
gC(1 : length(gcUS), 31)     = gcUS;    gC(1 : length(gcVen), 32)    = gcVen;   

% initializing
disaster_prob = zeros(1, length(T));        % disaster probability: C
disaster_size = zeros(1, length(T));        % disaster mean size: C
disaster_dura = zeros(1, length(T));        % disaster mean duration: C

% dynamic matrix for all countries: each row is each disaster, and the two columns are size and duration of the disaster
disCall  = [];                     
d_cutoff = .10

% apply the peak-to-trough measurement for C disasters
for n = 1 : length(T)
    
    % obtain country n's gY vector
    gCvec    = gC(1 : T(n), n) - 1.7411/100; 
    % 
    gCneg    = find(gCvec < 0);        % find index of negative C growth 
    disC     = [];                     % dynamic matrix: each row is each disaster, and the two columns are size and duration of the disaster
    p_peak   = 1;
    p_trough = p_peak;
    
    while p_trough < length(gCneg), 
        while gCneg(p_trough + 1) == gCneg(p_trough) + 1,   
            p_trough = p_trough + 1; 
            if p_trough >= length(gCneg)
                break
            end
        end
        % 
        dsize = sum(gCvec(gCneg(p_peak : p_trough))); 
        if abs(dsize) > d_cutoff,
            disC = [disC; [dsize p_trough - p_peak + 1]]; 
        end
        p_peak   = p_trough + 1; 
        p_trough = p_peak; 
    end
     
    % calculate all the disaster statistics for the n-th country
    if length(disC) > 0 
        % disaster statistics
        disaster_prob(n) = size(disC, 1)/(T(n) - sum(disC(:, 2))); 
        disaster_size(n) = mean(disC(:, 1)); 
        disaster_dura(n) = mean(disC(:, 2)); 
        
    else
        disp(['no disasters in country ' num2str(n) '...'])
    end
    
    % accumulate the disaster matrix across all countries 
    disCall = [disCall; disC]; 

end % for the n-th country 


% averaging across all countries - not barro-ursua calculation
% mean_prob = mean(disaster_prob)
% mean_size = mean(disaster_size)
% mean_dura = mean(disaster_dura)

% barro-ursua calculation
disaster_prob_all = size(disCall, 1)/( sum(T) - sum(disCall(:, 2)) )
disaster_size_all = mean(disCall(:, 1))
disaster_dura_all = mean(disCall(:, 2)) 


