% DISASTER_MOMENTS_COUNTRIES_Y:
%   Calculate disaster moments in the updated Barro-Ursua C and Y data, following 
% the Barro and Ursua peak-to-trough measurement of disasters
% 
% July 4, 2014


clear all; close all; clc; format compact; format long; 

load Y_BarroUrsua_update_July2014

% define Y growth rates for countries
gyArg     = log(yArg(2 : end)) - log(yArg(1 : end - 1));            gyAus     = log(yAus(2 : end)) - log(yAus(1 : end - 1));        gyAustria = log(yAustria(2 : end)) - log(yAustria(1 : end - 1)); 
gyBel     = log(yBel(2 : end)) - log(yBel(1 : end - 1));            gyBra     = log(yBra(2 : end)) - log(yBra(1 : end - 1));        gyBel     = log(yBel(2 : end)) - log(yBel(1 : end - 1)); 
gyCan     = log(yCan(2 : end)) - log(yCan(1 : end - 1));            gyChi     = log(yChi(2 : end)) - log(yChi(1 : end - 1));        gyChina   = log(yChina(2 : end)) - log(yChina(1 : end - 1)); 
gyCol     = log(yCol(2 : end)) - log(yCol(1 : end - 1));            gyDen     = log(yDen(2 : end)) - log(yDen(1 : end - 1));        gyEgy     = log(yEgy(2 : end)) - log(yEgy(1 : end - 1)); 
gyFin     = log(yFin(2 : end)) - log(yFin(1 : end - 1));            gyFra     = log(yFra(2 : end)) - log(yFra(1 : end - 1));        gyGer     = log(yGer(2 : end)) - log(yGer(1 : end - 1)); 
gyIce     = log(yIce(2 : end)) - log(yIce(1 : end - 1));            gyInd     = log(yInd(2 : end)) - log(yInd(1 : end - 1));        gyIndo    = log(yIndo(2 : end)) - log(yIndo(1 : end - 1)); 
gyIta     = log(yIta(2 : end)) - log(yIta(1 : end - 1));            gyJap     = log(yJap(2 : end)) - log(yJap(1 : end - 1));        gyKor     = log(yKor(2 : end)) - log(yKor(1 : end - 1)); 
gyMex     = log(yMex(2 : end)) - log(yMex(1 : end - 1));            gyNet     = log(yNet(2 : end)) - log(yNet(1 : end - 1));        gyNew     = log(yNew(2 : end)) - log(yNew(1 : end - 1)); 
gyNor     = log(yNor(2 : end)) - log(yNor(1 : end - 1));            gyPer     = log(yPer(2 : end)) - log(yPer(1 : end - 1));        gyPor     = log(yPor(2 : end)) - log(yPor(1 : end - 1)); 
gyRus     = log(yRus(2 : end)) - log(yRus(1 : end - 1));            gySaf     = log(ySaf(2 : end)) - log(ySaf(1 : end - 1));        gySpa     = log(ySpa(2 : end)) - log(ySpa(1 : end - 1)); 
gySri     = log(ySri(2 : end)) - log(ySri(1 : end - 1));            gySwe     = log(ySwe(2 : end)) - log(ySwe(1 : end - 1));        gySwi     = log(ySwi(2 : end)) - log(ySwi(1 : end - 1)); 
gyTai     = log(yTai(2 : end)) - log(yTai(1 : end - 1));            gyTur     = log(yTur(2 : end)) - log(yTur(1 : end - 1));        gyUK      = log(yUK(2 : end)) - log(yUK(1 : end - 1)); 
gyUS      = log(yUS(2 : end)) - log(yUS(1 : end - 1));              gyUru     = log(yUru(2 : end)) - log(yUru(1 : end - 1));        gyVen     = log(yVen(2 : end)) - log(yVen(1 : end - 1)); 

% use patched nan to put all the gy vectors in a matrix of max(T) by N = columns of T
T = [length(gyArg) length(gyAus) length(gyAustria) length(gyBel) length(gyBra) length(gyCan) length(gyChi) length(gyChina) ...
     length(gyCol) length(gyDen) length(gyEgy) length(gyFin) length(gyFra) length(gyGer) length(gyIce) length(gyInd) ...
     length(gyIndo) length(gyIta) length(gyJap) length(gyKor) length(gyMex) length(gyNet) length(gyNew) length(gyNor) ...
     length(gyPer) length(gyPor) length(gyRus) length(gySaf) length(gySpa) length(gySri) length(gySwe) length(gySwi) ...
     length(gyTai) length(gyTur) length(gyUK) length(gyUru) length(gyUS) length(gyVen)]; 

gY = NaN*ones(max(T), length(T)); 
gY(1 : length(gyArg), 1)     = gyArg;   gY(1 : length(gyAus), 2)     = gyAus;   gY(1 : length(gyAustria), 3) = gyAustria;   gY(1 : length(gyBel), 4)     = gyBel;   gY(1 : length(gyBra), 5)     = gyBra;   gY(1 : length(gyCan), 6)     = gyCan; 
gY(1 : length(gyChi), 7)     = gyChi;   gY(1 : length(gyChina), 8)   = gyChina; gY(1 : length(gyCol), 9)     = gyCol;       gY(1 : length(gyDen), 10)    = gyDen;   gY(1 : length(gyEgy), 11)    = gyEgy;   gY(1 : length(gyFin), 12)    = gyFin; 
gY(1 : length(gyFra), 13)    = gyFra;   gY(1 : length(gyGer), 14)    = gyGer;   gY(1 : length(gyIce), 15)    = gyIce;       gY(1 : length(gyInd), 16)    = gyInd;   gY(1 : length(gyIndo), 17)   = gyIndo;  gY(1 : length(gyIta), 18)    = gyIta; 
gY(1 : length(gyJap), 19)    = gyJap;   gY(1 : length(gyKor), 20)    = gyKor;   gY(1 : length(gyMex), 21)    = gyMex;       gY(1 : length(gyNet), 22)    = gyNet;   gY(1 : length(gyNew), 23)    = gyNew;   gY(1 : length(gyNor), 24)    = gyNor; 
gY(1 : length(gyPer), 25)    = gyPer;   gY(1 : length(gyPor), 26)    = gyPor;   gY(1 : length(gyRus), 27)    = gyRus;       gY(1 : length(gySaf), 28)    = gySaf;   gY(1 : length(gySpa), 29)    = gySpa;   gY(1 : length(gySri), 30)    = gySri; 
gY(1 : length(gySwe), 31)    = gySwe;   gY(1 : length(gySwi), 32)    = gySwi;   gY(1 : length(gyTai), 33)    = gyTai;       gY(1 : length(gyTur), 34)    = gyTur;   gY(1 : length(gyUK), 35)     = gyUK;    gY(1 : length(gyUru), 36)    = gyUru; 
gY(1 : length(gyUS), 37)     = gyUS;    gY(1 : length(gyVen), 38)    = gyVen;   

% initializing
disaster_prob = zeros(1, length(T));        % disaster probability: Y
disaster_size = zeros(1, length(T));        % disaster mean size: Y
disaster_dura = zeros(1, length(T));        % disaster mean duration: Y

% dynamic matrix for all countries: each row is each disaster, and the two columns are size and duration of the disaster
disYall  = [];                          
d_cutoff = .10

% apply the peak-to-trough measurement for GDP disasters
for n = 1 : length(T)
    
    % obtain country n's gY vector
    gYvec    = gY(1 : T(n), n) - 1.8472/100; 
    % 
    gYneg    = find(gYvec < 0);        % find index of negative Y growth 
    disY     = [];                     % dynamic matrix: each row is each disaster, and the two columns are size and duration of the disaster
    p_peak   = 1;
    p_trough = p_peak;
    
    while p_trough < length(gYneg), 
        while gYneg(p_trough + 1) == gYneg(p_trough) + 1,   
            p_trough = p_trough + 1; 
            if p_trough >= length(gYneg)
                break
            end
        end
        % 
        dsize = sum(gYvec(gYneg(p_peak : p_trough))); 
        if abs(dsize) > d_cutoff,
            disY = [disY; [dsize p_trough - p_peak + 1]]; 
        end
        p_peak   = p_trough + 1; 
        p_trough = p_peak; 
    end
     
    % calculate all the disaster statistics for the n-th country
    if length(disY) > 0 
        % disaster statistics
        disaster_prob(n) = size(disY, 1)/(T(n) - sum(disY(:, 2))); 
        disaster_size(n) = mean(disY(:, 1)); 
        disaster_dura(n) = mean(disY(:, 2)); 
        
    else
        disp(['no disasters in country ' num2str(n) '...'])
    end
    
    % accumulate the disaster matrix across all countries 
    disYall = [disYall; disY]; 

end % for the n-th country 


% averaging across all countries - not barro-ursua calculation
% mean_prob = mean(disaster_prob)
% mean_size = mean(disaster_size)
% mean_dura = mean(disaster_dura)


disaster_prob_all = size(disYall, 1)/( sum(T) - sum(disYall(:, 2)) )
disaster_size_all = mean(disYall(:, 1))
disaster_dura_all = mean(disYall(:, 2)) 

