% PROJECTION_HOME_PRODUCTION_E0P9: 
% 
% Use projection methods to solve the endogenous disasters model with home
% production, comparative static with e = 0.9
% 
%   Nicolas Petrosky-Nadeau, Lu Zhang, and Lars Kuehn, January 2018


clear all; close all; clc; format compact; format long

rhox    = .95^(1/3)
stdx    = .014
beta    = exp( -(log(1.0573))/12 )               
eta     = .04                                        % worker's bargaining weight 
b       = .5                                         % value of unemployment benefit    
kappa0  = .5
kappa1  = .5
% 
nu      = 1.25
s       = .04                                       % separation rate 
A       = .8
e       = .9
c0      = 1 
%
params  = {kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta, A, e, c0};


% Compute deterministic steady state (needs correction for home production)
Y0      = [4];
opts    = optimset('Display', 'Iter', 'MaxIter', 50);
[Y, fval, exitflag]  = fsolve('HomeProd_steadystate', Y0, opts, params);
thetass = Y(1) 

qss     = (thetass^nu + 1)^(-1/nu);
fss     = qss*thetass;
uss     = s/(fss + s) 
nss     = 1 - uss;
vss     = thetass*uss;
kappatss= kappa0 + kappa1*qss
cnss    = c0*uss
cmss    = nss - kappatss*vss
css     = ( A*cmss^e + (1-A)*cnss^e )^(1/e)
% phi   = A*(cmss^(e-1))*css^(-e)
zss     = c0*((1-A)/A)*(cmss/cnss)^(1-e) + b
wss     = eta*(1 + (kappa0 + kappa1*qss)*thetass) + (1 - eta)*zss
yss     = nss
% 
SS      = {uss, qss, fss, thetass, yss, vss, css, wss, cmss, cnss};


% discretize aggregate shocks via the Rouwenhorst (1995) method
nx        = 17                                        % the number of grid points for x, a column vector
xdev      = 2*stdx/sqrt((1 - rhox^2)*(nx - 1));
[P, x]    = rouwTrans(rhox, 0, xdev, nx);             % Qx_ij is the probability of jumping to state i next period given the current state of j

% ground work for cubic splines
nn        = 50                                        % # of elements in splines = number of N grid points
Nmin      = .4
Nmax      = .99
fspace    = fundefn('spli', nn, Nmin, Nmax);
N         = funnode(fspace);

% define a cell array to pass parameters to the residual function
Xm        = repmat(exp(x)', [nn 1]);
X_p       = permute(repmat(Xm, [1 1 nx]), [1 3 2]);
% a more intuitive construction of X_p:
% X_p     = zeros(nn, nx, nx);
% for ip  = 1 : nx
%    X_p(:, :, ip) = exp(x(ip))*ones(nn, nx);  
% end
Nm        = repmat(N, [1 nx]);
gridsetup = {P, x, Xm, X_p, N, Nm, fspace};


load output_proj_home_production_e0p9  aE 
    
a0 = [aE(:)];

% solve for projection coefficients

precision = 0
if precision == 0
    opts = optimset('Display', 'Iter', 'MaxIter', 500);
elseif precision == 1
    opts = optimset('Display', 'Iter', 'MaxIter', 100, 'TolFun', 1e-12, 'TolX', 1e-12);
end

[a, fval, exitflag]  = fsolve('residual_home_production', a0, opts, params, gridsetup);

exitflag

aE      = reshape(a(1 : nn*nx), [nn nx]);

if exitflag == 1
    save output_proj_home_production  aE params gridsetup SS
end

