function err = HomeProd_steadystate(Y0, params)

% labor search with home production 
% 
%  Nicolas Petrosky-Nadeau, and Lu Zhang, 2015

[kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta, A, e, c0] = params{:};

thetass  = Y0(1); 
qss      = (thetass^nu + 1)^(-1/nu);
fss      = qss*thetass;
uss      = s/(fss+s);
nss      = 1-uss;
vss      = thetass*uss;
kappatss = kappa0 + kappa1*qss;

cnss     = c0*uss;
cmss     = nss - kappatss*vss ;
zss      = c0*((1-A)/A)*(cmss/cnss)^(1-e) + b;
wss      = eta*(1 + (kappa0 + kappa1*qss)*thetass) + (1 - eta)*zss;

err      = kappatss*(1/beta - 1 + s) - (1 - wss);
