% MOMONGRID_HOME_PRODUCTION: 
% Plot quantity moments on the (N x) grid in the search model with home production
% 
%   Nicolas Petrosky-Nadeau, Lu Zhang, and Lars Kuehn, January 2018


clear all; clc; close all; format compact; format long; 


load output_proj_home_production

[kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta, A, e, c0] = params{:};
[Qx, x, Xmtrx, X_p, N, Nmtrx, fspace] = gridsetup{:};

nn     = length(N); 
nx     = length(x); 
Nmin   = min(N);
Nmax   = max(N); 


% plot residuals on the  the job creation condition and G function
a   = reshape(aE, [nn*nx 1]); 
err = residual_home_production(a, params, gridsetup);
eE  = reshape_home_production(err(1 : nn*nx), [nn nx]);

figure(1); mesh(x, N, eE, 'LineWidth', 2); 
ylabel('Employment', 'FontS', 25); xlabel('Productivity', 'FontS', 25); % zlabel('The conditional expectation error', 'FontS', 15); 
set(gca, 'FontS', 25); print -depsc errE_home_production.eps


% plot optimal policy and value functions and quantity moments
E            = funeval(aE, fspace, N);

q            = kappa0./(E - kappa1); 
q            = min(q, 1); 
q(q<0)       = 1; 
lambda       = zeros(nn, nx);
lambda(q==1) = kappa0 + kappa1 - E(q==1); 

mu           = kappa0./q + kappa1 - lambda; 
theta        = ( q.^(-nu) - 1 ).^(1/nu);
f            = theta.*q; 
V            = theta.*(1 - Nmtrx);
kappat       = kappa0 + kappa1*q; 
Cm           = Xmtrx.*Nmtrx - kappat.*V; 
Cn           = c0*(1 - Nmtrx); 
C            = ( A*(Cm.^e) + (1-A)*(Cn.^e) ).^(1/e); 
Y            = Xmtrx.*Nmtrx; 
z            = c0*((1-A)/A)*( (Cm./Cn).^(1-e) ) + b; 
W            = eta*(Xmtrx + kappat.*theta) + (1 - eta)*z; 


% save key moments on the grid for interpolation purpose later
save moments_theory_home_production  E q lambda theta V C  

