function err = residual_home_production(a0, params, gridsetup)

% residual functino with for the labor search model with home production 
% 
%  Nicolas Petrosky-Nadeau, Lu Zhang, and Lars Kuehn, January 2018


[kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta, A, e, c0] = params{:};
[P, x, Xm, X_p, N, Nm, fspace] = gridsetup{:};
 
nn       = length(N);
nx       = length(x);
Nmin     = min(N);
Nmax     = max(N);


aE       = reshape(a0(1 : nn*nx), [nn nx]);
E        = funeval(aE, fspace, N);

% labor market tightness and vacancies
q        = kappa0./(E - kappa1); 
q        = min(q, 1);
q(q<0)   = 1;
theta    = ( q.^(-nu) - 1 ).^(1/nu);
V        = theta.*(1 - Nm);
kappat   = kappa0 + kappa1*q; 

% home production
Cn       = c0*(1 - Nm);
% market consumption
Cm       = Xm.*Nm - kappat.*V ;
% Consumption bundle
C        = ( A*(Cm.^e) + (1-A)*(Cn.^e) ).^(1/e);

N_p      = (1 - s)*Nm + q.*V;
N_p      = min( Nmax, max(Nmin, N_p) );


E_p      = zeros(nn, nx, nx);

for ip = 1 : nx  % given x_t+1 = x(ip)
    E_p(:, :, ip) = reshape(funeval( aE(:, ip), fspace, reshape(N_p, [nn*nx 1]) ), [nn nx]);
end


% Labor market tightness and vacancies
q_p      = kappa0./(E_p - kappa1);
q_p      = min(1, q_p);
q_p(q_p<0) = 1;

theta_p  = ( q_p.^(-nu) - 1 ).^(1/nu);
kappat_p = kappa0 + kappa1*q_p; 

lambda_p = zeros(nn, nx, nx);
lambda_p(q_p==1) = kappa0 + kappa1 - E_p(q_p==1);


% N_p, U_p, and C are independent of x(t+1)
N_p     = repmat(N_p, [1 1 nx]);
U_p     = 1 - N_p;
V_p     = theta_p.*U_p;                   

C       = repmat(C, [1 1 nx]);          % for discounting
Cm      = repmat(Cm, [1 1 nx]);         % for discounting


% home production
Cn_p    = c0*(1-N_p);
% marke consumption
Cm_p    = X_p.*N_p - kappat_p.*V_p ;
% consumption bundle
C_p     = ( A*(Cm_p.^e) + (1-A)*(Cn_p.^e) ).^(1/e);


% wages
z_p     = c0*((1-A)/A)*( (Cm_p./Cn_p).^(1-e) ) + b;
W_p     = eta*( X_p + kappat_p.*theta_p ) + (1 - eta)*z_p;


% stochastic discount factor
M_p      = beta*( (Cm_p./Cm).^(e-1) ).*( (C./C_p).^e );
inside_p = M_p.*( X_p - W_p + (1 - s)*(kappa0./q_p + kappa1 - lambda_p) );

rhs    = zeros(nn, nx);
for ix = 1 : nx
    rhs(:, ix) = squeeze(inside_p(:, ix, :)) * P(:, ix) ;
end

eV      = E - rhs;
err     = [eV(:)];






