
function [sx, sindex] = DiscSimu(xinl, x, Qx, T)

% DISCSIMU:
%   Simulate an Markov Chain directly from the discrete state space
%
% USAGE:
%   xinl - initial value of x
%   x    - the discrete state space
%   Qx   - Markov transition matrix from Rouwenhorst's method
%   T    - sample length

sindex    = zeros(1, T); 
sindex(1) = find(x == xinl);
shock     = rand(1, T);
cQx       = cumsum(Qx); 

for t = 2 : T
    sindex(t) = sum(shock(t) > cQx(:, sindex(t - 1))) + 1;
end

sx = x(sindex)'; 

