% MOMONGRID_RU_LOG_UTILITY:  
% Plot quantity and financial moments on the (N x) grid for the recursive utility model with gamma = psi = 1 
% (log utility, but calibrated with the other parameters as in the recursive utility model)
% 
%  Nicolas Petrosky-Nadeau, Lu Zhang, and Lars Kuehn, January 2018


clear all; close all; format compact; 

load output_proj_RU_log_utility

[kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta] = params{:};
[Qx, x, Xmtrx, X_p, N, Nmtrx, fspace] = gridsetup{:};

nn     = length(N); 
nx     = length(x); 
Nmin   = min(N);
Nmax   = max(N); 


% plot optimal policy and value functions and quantity moments
E            = funeval(aE, fspace, N);
q            = kappa0./(E - kappa1); 
q            = min(q, 1); 
q(q<0)       = 1; 
lambda       = zeros(nn, nx);
lambda(q==1) = kappa0 + kappa1 - E(q==1); 

mu           = kappa0./q + kappa1 - lambda; 
margcosts    = kappa0./q + kappa1; 
theta        = ( q.^(-nu) - 1 ).^(1/nu);
f            = theta.*q; 
V            = theta.*(1 - Nmtrx);
kappat       = kappa0 + kappa1*q; 
C            = Xmtrx.*Nmtrx - kappat.*V; 
Y            = Xmtrx.*Nmtrx; 
W            = eta*(Xmtrx + kappat.*theta) + (1 - eta)*b; 


% plot financial moments with 3d-matrx operations
Np       = (1 - s)*Nmtrx + q.*V;  
Np       = min( Nmax, max(Nmin, Np) ); 
Up       = 1 - Np; 
Np3dmtrx = repmat(Np, [1 1 nx]); 

Ep     = zeros(nn, nx, nx);
for ix = 1 : nx % given Productivity = x(ix)
    for ip = 1 : nx % given Productivity+1 = x(ip)
        Ep(:, ix, ip) = funeval(aE(:, ip), fspace, Np(:, ix));
    end
end

qp             = kappa0./(Ep - kappa1); 
qp             = min(qp, 1); 
qp(qp<0)       = 1; 
lambdap        = zeros(nn, nx, nx);
lambdap(qp==1) = kappa0 + kappa1 - Ep(qp==1); 
mup            = kappa0./qp + kappa1 - lambdap;
thetap         = ( qp.^(-nu) - 1 ).^(1/nu);
Vp             = thetap.*(1 - Np3dmtrx); 
kappatp        = kappa0 + kappa1*qp; 
Cp             = X_p.*Np3dmtrx - kappatp.*Vp; 
Yp             = X_p.*Np3dmtrx; 
Wp             = eta*(X_p + kappatp.*thetap) + (1 - eta)*b; 
Dp             = Cp - Wp.*Np3dmtrx; 

% expected return
Rpnum   = X_p - Wp + (1 - s)*mup; 
ERpnum  = zeros(nn, nx);  
for ix  = 1 : nx
    ERpnum(:, ix) = squeeze(Rpnum(:, ix, :)) * Qx(:, ix);
end
% ER    = log(ERpnum./mu); 
ER      = ERpnum./mu - 1; 


% stock price P = mu*N'
P = mu.*Np; 
D = Xmtrx.*Nmtrx - W.*Nmtrx - kappat.*V; 


% real interest rate
Mnum  = beta ./Cp; 
EMnum = zeros(nn, nx); 
for ix = 1 : nx    
    EMnum(:, ix) = squeeze(Mnum(:, ix, :)) * Qx(:, ix);
end
EM = EMnum .* C; 
% Rf = log(1./EM); 
Rf = 1./EM - 1; 


% the equity premium
ERP = ER - Rf; 

% conditional market volatility 
Rpnum    = X_p - Wp + (1 - s)*mup; 
RpnumSq  = Rpnum.^2; 

ERpnum   = zeros(nn, nx); 
ERpnumSq = zeros(nn, nx); 
for ix = 1 : nx
    ERpnum(:, ix) = squeeze(Rpnum(:, ix, :)) * Qx(:, ix);
    ERpnumSq(:, ix) = squeeze(RpnumSq(:, ix, :)) * Qx(:, ix);
end
ERSq = ERpnumSq ./(mu.^2); 
ERq  = ERpnum ./mu; 
Vol  = ( ERSq - ERq.^2 ).^(1/2); 


% save key moments on the grid for interpolation purpose later
save moments_theory_RU_log_utility  E q lambda theta V C Np Ep qp thetap lambdap Up Vp Wp Dp Vol ERP Rf

