% STATDISTR_CONTINUOUS_STATE: 
% Simulate the stationary distribution for the model economy
% 
%  Nicolas Petrosky-Nadeau, Lu Zhang, and Lars Kuehn, January 2018


clear all; close all; clc; format compact; format short; 


if 1 % set 1 to 0 if you have run the code once and saved the (large) distribution file
load output_proj_log_utility
load moments_theory_log_utility

[kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta] = params{:};
[P, x, Xm, X_p, N, Nm, fspace] = gridsetup{:};
[uss, qss, fss, thetass, yss, vss, css, wss] = SS{:};

nn      = length(N); 
nx      = length(x);
Nmin    = min(N);
Nmax    = max(N);

burnin  = 500*12; 
% + 1 to ensure excess returns to have nsim*1020 periods
T       = burnin + 1e6 + 1

% simulating artificial data in continuous state space
[x_t, xinlnew] = CspSimu(0, 0, rhox, stdx, min(x), max(x), T); 
expx_t         = exp(x_t)';

N_t      = zeros(T + 1, 1);
V_t      = zeros(T, 1);
E_t      = zeros(T, 1);
q_t      = zeros(T, 1);
theta_t  = zeros(T, 1);
N_t(1)   = 1 - uss;

tic;
for t = 1 : T
    % 
    E_t(t)  = interp2(x, N, E, x_t(t), N_t(t), 'spline');
    %
    % labor market variables
    q       = kappa0./(E_t(t) - kappa1);
    q       = min(q,1);
    q(q<0)  = 1;
    q_t(t)  = q;
    %
    theta_t(t) = ( q.^(-nu) - 1 ).^(1/nu);
    V_t(t)     = theta_t(t).*(1 - N_t(t));
    N_t(t+1)   = (1 - s)*N_t(t) + q_t(t)*V_t(t);
    N_t(t+1)   = min(Nmax, max(Nmin, N_t(t+1)));
    %
    if mod(t, 1e5) == 0
        toc
    end
    % 
end

% house cleaning 
N_t(end)     = [];
ini          = 1 : burnin; 
expx_t(ini)  = [];
N_t(ini)     = [];
V_t(ini)     = [];
E_t(ini)     = [];
q_t(ini)     = [];
theta_t(ini) = [];

% calculating variables of interest
Y_t      = expx_t.*N_t;
C_t      = Y_t - kappat_t.*V_t;
% 2d interpolation makes C_t occasionally negative - never a problem for discrete state simulations
C_t      = max(.005, C_t);
U_t      = 1 - N_t;

save stationary_distribution_log_utility_continuous_state
else
load stationary_distribution_log_utility_continuous_state
end

% negatively skewed distributions with crashes
% 
C_t = C_t(1 : 1000000);
[f,x,flo,fup] = ecdf(C_t);
figure; stairs(x,f,'LineWidth',8); xlabel('Consumption', 'FontS', 25);  ylabel('Probability', 'FontS', 25); 
set(gca, 'FontS', 25); % print -depsc ecdf_Ct.eps
%
Y_t = Y_t(1 : 1000000);
[f,x,flo,fup] = ecdf(Y_t);
figure; stairs(x,f,'LineWidth',8); xlabel('Output', 'FontS', 25);  ylabel('Probability', 'FontS', 25); 
set(gca, 'FontS', 25); % print -depsc ecdf_Yt.eps
%
U_t = U_t(1 : 1000000);
[f,x,flo,fup] = ecdf(U_t);
figure; stairs(x,f,'LineWidth',8); xlabel('Unemployment', 'FontS', 25);  ylabel('Probability', 'FontS', 25); 
set(gca, 'FontS', 25); % print -depsc ecdf_Ut.eps

