% MOMONGRID: 
% Plot key moments on the (N x) grid
% 
%  Nicolas Petrosky-Nadeau, Lu Zhang, and Lars Kuehn, January 2018


clear all; close all; format compact; 

load output_proj_log_utility

[kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta] = params{:};
[Qx, x, Xmtrx, X_p, N, Nmtrx, fspace] = gridsetup{:};

nn     = length(N); 
nx     = length(x); 
Nmin   = min(N);
Nmax   = max(N); 

% plot residuals on the J function and the job creation condition
a   = reshape(aE, [nn*nx 1]);
       
err = residual_log_utility(a, params, gridsetup);
eE  = reshape(err(1 : nn*nx), [nn nx]);

figure(1); mesh(x, N, eE, 'LineWidth', 2); 
ylabel('Employment', 'FontS', 25); xlabel('Log productivity', 'FontS', 25); % zlabel('The conditional expectation error', 'FontS', 15); 
set(gca, 'FontS', 25); % print -depsc errE_log_utility.eps

% plot optimal policy and value functions and quantity moments
E            = funeval(aE, fspace, N);
q            = kappa0./(E - kappa1); 
q            = min(q, 1); 
q(q<0)       = 1; 
lambda       = zeros(nn, nx);
lambda(q==1) = kappa0 + kappa1 - E(q==1); 

mu           = kappa0./q + kappa1 - lambda; 
margcosts    = kappa0./q + kappa1; 
theta        = ( q.^(-nu) - 1 ).^(1/nu);
f            = theta.*q; 
V            = theta.*(1 - Nmtrx);
kappat       = kappa0 + kappa1*q; 
C            = Xmtrx.*Nmtrx - kappat.*V; 
Y            = Xmtrx.*Nmtrx; 
W            = eta*(Xmtrx + kappat.*theta) + (1 - eta)*b; 


q2d = q(:, [3 9 15]);
figure; plot(N, q2d(:, 1), 'b-', 'LineWidth', 8); hold on;
plot(N, q2d(:, 2), 'r--', 'LineWidth', 8);
plot(N, q2d(:, 3), 'k-.', 'LineWidth', 8); hold off; 
xlabel('Employment', 'FontS', 25); set(gca, 'FontS', 25);
% print -depsc q2d.eps


mc2d = margcosts(:, [3 9 15]);
figure; plot(N, mc2d(:, 1), 'b-', 'LineWidth', 8); hold on;
plot(N, mc2d(:, 2), 'r--', 'LineWidth', 8);
plot(N, mc2d(:, 3), 'k-.', 'LineWidth', 8); hold off; 
xlabel('Employment', 'FontS', 25); set(gca, 'FontS', 25);
% print -depsc mc2d.eps

save moments_theory_log_utility  E

