
function [corrvec] = myAutoCorr(X, Lags)

%-----------------------------------------------------------------------------------
% MYAUTOCORR:
%   evaluate autocorrelations of vectors X of orders defined in lags
%
% Usage:
%   X    - a time series of observations
%   Lags - a vector of positive integers defined the orders of autocorrelation 
%
% OUTPUT:
%   corrvec - a vector of autocorrelations of orders in Lags
%-----------------------------------------------------------------------------------

M       = length(Lags);
corrvec = zeros(M, 1);

Lags  = sort(Lags);
for j = 1 : M
    tmp = corrcoef(X(Lags(j) + 1 : end), X(1 : end - Lags(j)));
    corrvec(j) = tmp(1, 2);
end
