function err = residual_log_utility(a0, params, gridsetup)

% 2/16/2012: a bug fix in the residual function involving X_p - the 3rd dimension should vary, not the 2nd dimension


[kappa0, kappa1, eta, b, s, nu, rhox, stdx, beta] = params{:};
[P, x, Xm, X_p, N, Nm, fspace] = gridsetup{:};
 
nn      = length(N);
nx      = length(x);
Nmin    = min(N);
Nmax    = max(N);

aE      = reshape(a0(1 : nn*nx), [nn nx]);
E       = funeval(aE, fspace, N);

q       = kappa0./(E - kappa1); 
q       = min(q, 1);
q(q<0)  = 1;
theta   = ( q.^(-nu) - 1 ).^(1/nu);

V       = theta.*(1 - Nm);
kappat  = kappa0 + kappa1*q; 
C       = Xm.*Nm - kappat.*V;

N_p      = (1 - s)*Nm + q.*V;
N_p      = min( Nmax, max(Nmin, N_p) );

E_p      = zeros(nn, nx, nx);

for ip = 1 : nx  % given x_t+1 = x(ip)
    E_p(:, :, ip) = reshape(funeval( aE(:, ip), fspace, reshape(N_p, [nn*nx 1]) ), [nn nx]);
end

q_p      = kappa0./(E_p - kappa1);
q_p      = min(1, q_p);
q_p(q_p<0) = 1;

theta_p  = ( q_p.^(-nu) - 1 ).^(1/nu);
kappat_p = kappa0 + kappa1*q_p; 

lambda_p = zeros(nn, nx, nx);
lambda_p(q_p==1) = kappa0 + kappa1 - E_p(q_p==1);

% N_p and C are independent of x(t+1)
N_p     = repmat(N_p, [1 1 nx]);
C       = repmat(C, [1 1 nx]);

U_p     = 1 - N_p;
V_p     = theta_p.*U_p;                   % V_p(q_p==1) = 0;  % this command is redundant
C_p     = X_p.*N_p - kappat_p.*V_p;

% wage next period
W_p      = eta*(X_p + kappat_p.*theta_p) + (1 - eta)*b; 
M_p      = beta*(C./C_p);
inside_p = M_p.*( X_p - W_p + (1 - s)*(kappa0./q_p + kappa1 - lambda_p) );

rhs    = zeros(nn, nx);
for ix = 1 : nx
    rhs(:, ix) = squeeze(inside_p(:, ix, :)) * P(:, ix) ;
end

err    = E - rhs;

